import searchView from "../views/searchView.js";
import searchModel from "../models/searchModel.js";
import gameModel from "../models/gameModel.js";
import gameView from "../views/gameView.js";
import { state } from "../models/stateModel.js";
import { GAMES_PER_PAGE } from "../public/js/config.js";

const controlSearchGames = async function () {
  try {
    state.search.query = await searchModel.getSearchParams();
    const allGames = await gameModel.searchGames(state.search.query);
    state.search.results.notRotatedGames = allGames[0];
    state.search.results.rotatedGames = allGames[1];
    await gameView.renderGamesList(
      state.search.results.notRotatedGames,
      state.search.results.rotatedGames,
      "gamesListView"
    );
    const loopIterations = state.search.results.notRotatedGames.length;
    for (let index = 0; index < loopIterations; index++) {
      state.currentNotRotatedGame.notRotatedGameId =
        state.search.results.notRotatedGames[index][0];
      state.currentRotatedGame.rotatedGameId =
        state.search.results.rotatedGames[index][0];

      let GamesDomInfo = gameView.getGameInformationFromDom(
        state.currentNotRotatedGame.notRotatedGameId,
        state.currentRotatedGame.rotatedGameId
      );

      state.currentNotRotatedGame = GamesDomInfo[0];
      state.currentRotatedGame = GamesDomInfo[1];
      state.currentYTDSeries = GamesDomInfo[2];

      const forcastInfoArray = gameModel.searchGameForcastInformation(
        state.currentNotRotatedGame,
        state.currentRotatedGame,
        state.currentYTDSeries,
        state.search.results.notRotatedGames,
        state.search.results.rotatedGames
      );

      state.currentNotRotatedGame.notRotatedGameRoles =
        forcastInfoArray[0].notRotatedGameRoles;

      state.currentNotRotatedGame.notRotatedGameRoleValues =
        forcastInfoArray[0].notRotatedGameRoleValues;

      state.currentNotRotatedGame.notRotatedGameRolesQueryStrings =
        forcastInfoArray[0].notRotatedGameRolesQueryStrings;

      state.currentNotRotatedGame.notRotatedGameRolesForcast =
        forcastInfoArray[0].notRotatedGameRolesForcast;

      state.currentRotatedGame.rotatedGameRoles =
        forcastInfoArray[1].rotatedGameRoles;

      state.currentRotatedGame.rotatedGameRoleValues =
        forcastInfoArray[1].rotatedGameRoleValues;

      state.currentRotatedGame.rotatedGameRolesQueryStrings =
        forcastInfoArray[1].rotatedGameRolesQueryStrings;

      state.currentRotatedGame.rotatedGameRolesForcast =
        forcastInfoArray[1].rotatedGameRolesForcast;

      /*console.log(
        "Current no rotated game: " +
          state.currentNotRotatedGame.notRotatedGameId
      );
      console.log(
        "Current rotated game: " + state.currentRotatedGame.rotatedGameId
      );
      console.log(state.currentNotRotatedGame.notRotatedGameRoles);
      console.log(state.currentNotRotatedGame.notRotatedGameRoleValues);
      console.log(state.currentNotRotatedGame.notRotatedGameRolesQueryStrings);
      console.log(state.currentNotRotatedGame.notRotatedGameRolesForcast);

      console.log(state.currentRotatedGame.rotatedGameRoles);
      console.log(state.currentRotatedGame.rotatedGameRoleValues);
      console.log(state.currentRotatedGame.rotatedGameRolesQueryStrings);
      console.log(state.currentRotatedGame.rotatedGameRolesForcast);*/

      gameView.showTestingInformation(
        state.currentNotRotatedGame.notRotatedGameId,
        state.currentNotRotatedGame.notRotatedGameRoles,
        state.currentNotRotatedGame.notRotatedGameRoleValues,
        state.currentNotRotatedGame.notRotatedGameRolesQueryStrings,
        state.currentNotRotatedGame.notRotatedGameRolesForcast,
        state.currentRotatedGame.rotatedGameId,
        state.currentRotatedGame.rotatedGameRoles,
        state.currentRotatedGame.rotatedGameRoleValues,
        state.currentRotatedGame.rotatedGameRolesQueryStrings,
        state.currentRotatedGame.rotatedGameRolesForcast
      );

      gameView.renderGameForcastInformation(
        state.currentNotRotatedGame.notRotatedGameId,
        state.currentNotRotatedGame.notRotatedGameRoles,
        state.currentNotRotatedGame.notRotatedGameRolesForcast,
        state.currentRotatedGame.rotatedGameId,
        state.currentRotatedGame.rotatedGameRoles,
        state.currentRotatedGame.rotatedGameRolesForcast
      );
    }
    state.search.page = 1;
    state.search.resultsPerPage = GAMES_PER_PAGE;
  } catch (error) {
    console.error(error);
    /*gameView.renderError(error);*/
  }
};

const controlHomeAwayFavoriteDogCheckboxesManagement = function () {
  // functionality for turning on/off home/away check boxes at the same time
  gameView.manageHomeAwayFavoriteDogCheckboxes("home-away");
  // end functionality for turning on/off home/away check boxes at the same time
  // functionality for turning on/off favorite/dog check boxes at the same time
  gameView.manageHomeAwayFavoriteDogCheckboxes("favorite-dog");
  // end functionality for turning on/off favorite/dog check boxes at the same time
};

const controlApplyFilters = function () {
  try {
    const notRotatedGameIdFromDomTarget =
      gameView.getCurrentNotRotatedGameIdFromDomTarget(event.target);

    const rotatedGameId = gameModel.getRotatedGameId(
      notRotatedGameIdFromDomTarget,
      state.search.results.notRotatedGames,
      state.search.results.rotatedGames
    );

    state.currentNotRotatedGame.notRotatedGameId =
      notRotatedGameIdFromDomTarget;
    state.currentRotatedGame.rotatedGameId = rotatedGameId;

    let GamesDomInfo = gameView.getGameInformationFromDom(
      state.currentNotRotatedGame.notRotatedGameId,
      state.currentRotatedGame.rotatedGameId
    );

    state.currentNotRotatedGame = GamesDomInfo[0];
    state.currentRotatedGame = GamesDomInfo[1];
    state.currentYTDSeries = GamesDomInfo[2];

    const forcastInfoArray = gameModel.searchGameForcastInformation(
      state.currentNotRotatedGame,
      state.currentRotatedGame,
      state.currentYTDSeries,
      state.search.results.notRotatedGames,
      state.search.results.rotatedGames
    );

    state.currentNotRotatedGame.notRotatedGameRoles =
      forcastInfoArray[0].notRotatedGameRoles;

    state.currentNotRotatedGame.notRotatedGameRoleValues =
      forcastInfoArray[0].notRotatedGameRoleValues;

    state.currentNotRotatedGame.notRotatedGameRolesQueryStrings =
      forcastInfoArray[0].notRotatedGameRolesQueryStrings;

    state.currentNotRotatedGame.notRotatedGameRolesForcast =
      forcastInfoArray[0].notRotatedGameRolesForcast;

    state.currentRotatedGame.rotatedGameRoles =
      forcastInfoArray[1].rotatedGameRoles;

    state.currentRotatedGame.rotatedGameRoleValues =
      forcastInfoArray[1].rotatedGameRoleValues;

    state.currentRotatedGame.rotatedGameRolesQueryStrings =
      forcastInfoArray[1].rotatedGameRolesQueryStrings;

    state.currentRotatedGame.rotatedGameRolesForcast =
      forcastInfoArray[1].rotatedGameRolesForcast;

    /*console.log(
      "Current no rotated game: " + state.currentNotRotatedGame.notRotatedGameId
    );
    console.log(
      "Current rotated game: " + state.currentRotatedGame.rotatedGameId
    );
    console.log(state.currentNotRotatedGame.notRotatedGameRoles);
    console.log(state.currentNotRotatedGame.notRotatedGameRoleValues);
    console.log(state.currentNotRotatedGame.notRotatedGameRolesQueryStrings);
    console.log(state.currentNotRotatedGame.notRotatedGameRolesForcast);

    console.log(state.currentRotatedGame.rotatedGameRoles);
    console.log(state.currentRotatedGame.rotatedGameRoleValues);
    console.log(state.currentRotatedGame.rotatedGameRolesQueryStrings);
    console.log(state.currentRotatedGame.rotatedGameRolesForcast);*/

    gameView.showTestingInformation(
      state.currentNotRotatedGame.notRotatedGameId,
      state.currentNotRotatedGame.notRotatedGameRoles,
      state.currentNotRotatedGame.notRotatedGameRoleValues,
      state.currentNotRotatedGame.notRotatedGameRolesQueryStrings,
      state.currentNotRotatedGame.notRotatedGameRolesForcast,
      state.currentRotatedGame.rotatedGameId,
      state.currentRotatedGame.rotatedGameRoles,
      state.currentRotatedGame.rotatedGameRoleValues,
      state.currentRotatedGame.rotatedGameRolesQueryStrings,
      state.currentRotatedGame.rotatedGameRolesForcast
    );

    gameView.renderGameForcastInformation(
      state.currentNotRotatedGame.notRotatedGameId,
      state.currentNotRotatedGame.notRotatedGameRoles,
      state.currentNotRotatedGame.notRotatedGameRolesForcast,
      state.currentRotatedGame.rotatedGameId,
      state.currentRotatedGame.rotatedGameRoles,
      state.currentRotatedGame.rotatedGameRolesForcast
    );
  } catch (error) {
    console.error(error);
    /*gameView.renderError(error);*/
  }
};

const controlClearFilters = function () {
  try {
    const notRotatedGameIdFromDomTarget =
      gameView.getCurrentNotRotatedGameIdFromDomTarget(event.target);

    const rotatedGameId = gameModel.getRotatedGameId(
      notRotatedGameIdFromDomTarget,
      state.search.results.notRotatedGames,
      state.search.results.rotatedGames
    );

    state.currentNotRotatedGame.notRotatedGameId =
      notRotatedGameIdFromDomTarget;
    state.currentRotatedGame.rotatedGameId = rotatedGameId;

    let GamesDomInfo = gameView.clearGameInformationFromDom(
      state.currentNotRotatedGame.notRotatedGameId,
      state.currentRotatedGame.rotatedGameId
    );

    state.currentNotRotatedGame = GamesDomInfo[0];
    state.currentRotatedGame = GamesDomInfo[1];
    state.currentYTDSeries = GamesDomInfo[2];

    const forcastInfoArray = gameModel.searchGameForcastInformation(
      state.currentNotRotatedGame,
      state.currentRotatedGame,
      state.currentYTDSeries,
      state.search.results.notRotatedGames,
      state.search.results.rotatedGames
    );

    state.currentNotRotatedGame.notRotatedGameRoles =
      forcastInfoArray[0].notRotatedGameRoles;

    state.currentNotRotatedGame.notRotatedGameRoleValues =
      forcastInfoArray[0].notRotatedGameRoleValues;

    state.currentNotRotatedGame.notRotatedGameRolesQueryStrings =
      forcastInfoArray[0].notRotatedGameRolesQueryStrings;

    state.currentNotRotatedGame.notRotatedGameRolesForcast =
      forcastInfoArray[0].notRotatedGameRolesForcast;

    state.currentRotatedGame.rotatedGameRoles =
      forcastInfoArray[1].rotatedGameRoles;

    state.currentRotatedGame.rotatedGameRoleValues =
      forcastInfoArray[1].rotatedGameRoleValues;

    state.currentRotatedGame.rotatedGameRolesQueryStrings =
      forcastInfoArray[1].rotatedGameRolesQueryStrings;

    state.currentRotatedGame.rotatedGameRolesForcast =
      forcastInfoArray[1].rotatedGameRolesForcast;

    /*console.log(
      "Current no rotated game: " + state.currentNotRotatedGame.notRotatedGameId
    );
    console.log(
      "Current rotated game: " + state.currentRotatedGame.rotatedGameId
    );
    console.log(state.currentNotRotatedGame.notRotatedGameRoles);
    console.log(state.currentNotRotatedGame.notRotatedGameRoleValues);
    console.log(state.currentNotRotatedGame.notRotatedGameRolesQueryStrings);
    console.log(state.currentNotRotatedGame.notRotatedGameRolesForcast);

    console.log(state.currentRotatedGame.rotatedGameRoles);
    console.log(state.currentRotatedGame.rotatedGameRoleValues);
    console.log(state.currentRotatedGame.rotatedGameRolesQueryStrings);
    console.log(state.currentRotatedGame.rotatedGameRolesForcast);*/

    gameView.showTestingInformation(
      state.currentNotRotatedGame.notRotatedGameId,
      state.currentNotRotatedGame.notRotatedGameRoles,
      state.currentNotRotatedGame.notRotatedGameRoleValues,
      state.currentNotRotatedGame.notRotatedGameRolesQueryStrings,
      state.currentNotRotatedGame.notRotatedGameRolesForcast,
      state.currentRotatedGame.rotatedGameId,
      state.currentRotatedGame.rotatedGameRoles,
      state.currentRotatedGame.rotatedGameRoleValues,
      state.currentRotatedGame.rotatedGameRolesQueryStrings,
      state.currentRotatedGame.rotatedGameRolesForcast
    );

    gameView.renderGameForcastInformation(
      state.currentNotRotatedGame.notRotatedGameId,
      state.currentNotRotatedGame.notRotatedGameRoles,
      state.currentNotRotatedGame.notRotatedGameRolesForcast,
      state.currentRotatedGame.rotatedGameId,
      state.currentRotatedGame.rotatedGameRoles,
      state.currentRotatedGame.rotatedGameRolesForcast
    );
  } catch (error) {
    console.error(error);
    /*gameView.renderError(error);*/
  }
};

const init = async function () {
  try {
    gameView.addHandlerSearchGames(controlSearchGames);
    gameView.addHandlerHomeAwayFavoriteDogCheckboxes(
      controlHomeAwayFavoriteDogCheckboxesManagement
    );
    document.addEventListener("DOMContentLoaded", function () {
      // Since the DOM is built dinamically, is not possible to assign eventhandlers to unexisting dom objects, so inside this function which is executed after the DOM is generated we expose these functions to global scope, and functions are assign in the onclick html where it's needed.

      // this is used in the Apply filter buttons onclick event
      window.controlApplyFilters = controlApplyFilters;

      // this is used in the Clear buttons onclick event
      window.controlClearFilters = controlClearFilters;
    });
  } catch (error) {
    console.error(error);
    /*gameView.renderError(error);*/
  }
};

init();

// Controller for the whole functionality
// Vicente Padulo
// Feb 23,2025
// https://Vicentepadulo.com.ve
