import { equivalentVsRoleTable } from "../public/js/config.js";

class GameModel {
  async searchGames(searchParams) {
    try {
      const url = searchParams.jsonUrl;
      console.log("url: " + url);
      const response = await fetch(url);
      if (!response.ok) {
        throw new Error("Can not open the JSON file!");
      }

      const data = await response.json();
      const allGamesEntries = Array.from(Object.entries(data));

      if (Array.isArray(allGamesEntries)) {
        const allGamesEntriesFilteredByDate = this.getGamesFilteredByDate(
          allGamesEntries,
          searchParams.date
        );

        allGamesEntriesFilteredByDate.sort();

        let notRotatedGames = this.getNotRotatedGames(
          allGamesEntriesFilteredByDate
        );

        let rotatedGames = this.getRotatedGames(
          allGamesEntriesFilteredByDate,
          notRotatedGames
        );

        return [notRotatedGames, rotatedGames];
      } else {
        throw new Error("Error during games data array creation!");
      }
    } catch (error) {
      console.error(error);
      /*gameView.renderError(error);*/
    }
  }

  getGamesFilteredByDate(games, date) {
    try {
      const gamesFilteredByDate = [];

      for (let i = 0; i < games.length; i++) {
        if (games[i][1].dEventDate == date) {
          gamesFilteredByDate.push(games[i]);
        }
      }
      return gamesFilteredByDate;
    } catch (error) {
      console.error(error);
      /*gameView.renderError(error);*/
    }
  }

  getNotRotatedGames(allGamesEntriesFilteredByDate) {
    try {
      const notRotatedGames = [];

      allGamesEntriesFilteredByDate.forEach((element) => {
        if (
          this.findTeamsCoupleInArray(
            allGamesEntriesFilteredByDate,
            element[1].tTeamName,
            element[1].tFoeName
          ) &&
          this.findTeamsCoupleInArray(
            allGamesEntriesFilteredByDate,
            element[1].tFoeName,
            element[1].tTeamName
          )
        ) {
          if (
            !this.findTeamsCoupleInArray(
              notRotatedGames,
              element[1].tTeamName,
              element[1].tFoeName
            ) &&
            !this.findTeamsCoupleInArray(
              notRotatedGames,
              element[1].tFoeName,
              element[1].tTeamName
            )
          ) {
            notRotatedGames.push(element);
          }
        }
      });
      return notRotatedGames;
    } catch (error) {
      console.error(error);
      /*gameView.renderError(error);*/
    }
  }

  getRotatedGames(allGamesEntriesFilteredByDate, notRotatedGames) {
    try {
      const rotatedGames = [];
      let indexItemFound;

      notRotatedGames.forEach((element) => {
        indexItemFound = this.findIndexTeamsCoupleInArray(
          allGamesEntriesFilteredByDate,
          element[1].tFoeName,
          element[1].tTeamName
        );

        if (indexItemFound) {
          rotatedGames.push(allGamesEntriesFilteredByDate[indexItemFound]);
        } else {
          throw new Error("Error en la construccion del arreglo rotado!");
        }
      });
      return rotatedGames;
    } catch (error) {
      console.error(error);
      /*gameView.renderError(error);*/
    }
  }

  findTeamsCoupleInArray(games, teamA, teamB) {
    try {
      let itemFound = false;
      games.forEach((element, index) => {
        if (element[1].tTeamName == teamA && element[1].tFoeName == teamB) {
          itemFound = true;
        }
      });
      return itemFound;
    } catch (error) {
      console.error(error);
      /*gameView.renderError(error);*/
    }
  }

  findIndexTeamsCoupleInArray(games, teamA, teamB) {
    try {
      let indexFound;
      games.forEach((element, index) => {
        if (element[1].tTeamName == teamA && element[1].tFoeName == teamB) {
          indexFound = index;
        }
      });
      return indexFound;
    } catch (error) {
      console.error(error);
      /*gameView.renderError(error);*/
    }
  }

  searchGameForcastInformation(
    currentNotRotatedGame,
    currentRotatedGame,
    currentYTDSeries,
    notRotatedGames,
    rotatedGames
  ) {
    try {
      /*----------------------Not rotated game------------------------------*/

      //Define the arrays of role query string for not rotated and rotated games
      let notRotatedGameRolesQueryStrings = [];
      let rotatedGameRolesQueryStrings = [];
      //End define the arrays of role query string for not rotated and rotated games

      //Sort arrays of roles and roles values based on roles alphabetically for NOT ROTATED GAME
      const notRotatedGameRolesArrayBasedOn =
        currentNotRotatedGame.notRotatedGameRoles;
      const notRotatedGameRoleValuesArrayToSort =
        currentNotRotatedGame.notRotatedGameRoleValues;

      const notRotatedGameSortedArrays = this.sortTwoArraysBasedOnOne(
        notRotatedGameRolesArrayBasedOn,
        notRotatedGameRoleValuesArrayToSort
      );
      //End sort arrays of roles and roles values based on roles alphabetically for NOT ROTATED GAME

      //Build the default roles query strings for NOT ROTATED GAME
      const notRotatedGameRolesSorted =
        notRotatedGameSortedArrays.arrayBasedOnSorted;
      const notRotatedGameRoleValuesSorted =
        notRotatedGameSortedArrays.arrayToSortSorted;

      notRotatedGameRolesSorted.forEach((element) => {
        notRotatedGameRolesQueryStrings.push(element + "|" + currentYTDSeries);
      });
      //End build the default roles query strings for NOT ROTATED GAME

      //Now for each checked box turned on add the corresponding role to the role string for team "A"
      notRotatedGameRoleValuesSorted.forEach(
        (roleValueToCheckIfOn, roleValueToCheckIfOnIndex) => {
          if (roleValueToCheckIfOn && roleValueToCheckIfOn !== "") {
            for (
              let index = 0;
              index < notRotatedGameRolesQueryStrings.length;
              index++
            ) {
              notRotatedGameRolesQueryStrings[index] =
                notRotatedGameRolesQueryStrings[index] +
                "|" +
                notRotatedGameRolesSorted[roleValueToCheckIfOnIndex];

              notRotatedGameRolesQueryStrings[index] =
                this.RemoveDuplicatedRolesAndSortAlphabetically(
                  notRotatedGameRolesQueryStrings[index]
                );

              notRotatedGameRolesQueryStrings[index] =
                this.sendTheRoleSeriesToTheEndOfTheOrder(
                  notRotatedGameRolesQueryStrings[index]
                );
            }
          }
        }
      );
      //End Now for each checked box turned on add the corresponding role to the role string for team "A"

      /*----------------------Rotated game----------------------------------*/

      //Sort arrays of roles and roles values based on roles alphabetically for ROTATED GAME
      const rotatedGameRolesArrayBasedOn = currentRotatedGame.rotatedGameRoles;
      const rotatedGameRoleValuesArrayToSort =
        currentRotatedGame.rotatedGameRoleValues;
      const rotatedGameSortedArrays = this.sortTwoArraysBasedOnOne(
        rotatedGameRolesArrayBasedOn,
        rotatedGameRoleValuesArrayToSort
      );
      //End sort arrays of roles and roles values based on roles alphabetically for ROTATED GAME

      //Build the default roles query strings for ROTATED GAME
      const rotatedGameRolesSorted = rotatedGameSortedArrays.arrayBasedOnSorted;
      const rotatedGameRoleValuesSorted =
        rotatedGameSortedArrays.arrayToSortSorted;
      rotatedGameRolesSorted.forEach((element) => {
        rotatedGameRolesQueryStrings.push(element + "|" + currentYTDSeries);
      });
      //End build the default roles query strings for ROTATED GAME

      //Now for each checked box turned on add the corresponding role to the role string for team "B"
      rotatedGameRoleValuesSorted.forEach(
        (roleValueToCheckIfOn, roleValueToCheckIfOnIndex) => {
          if (roleValueToCheckIfOn && roleValueToCheckIfOn !== "") {
            for (
              let index = 0;
              index < rotatedGameRolesQueryStrings.length;
              index++
            ) {
              rotatedGameRolesQueryStrings[index] =
                rotatedGameRolesQueryStrings[index] +
                "|" +
                rotatedGameRolesSorted[roleValueToCheckIfOnIndex];
              rotatedGameRolesQueryStrings[index] =
                this.RemoveDuplicatedRolesAndSortAlphabetically(
                  rotatedGameRolesQueryStrings[index]
                );

              rotatedGameRolesQueryStrings[index] =
                this.sendTheRoleSeriesToTheEndOfTheOrder(
                  rotatedGameRolesQueryStrings[index]
                );
            }
          }
        }
      );
      //End now for each checked box turned on add the corresponding role to the role string for team "B"

      //Now we have to process the equivalent vs roles for the check boxes turned on for both teams
      //Look for checkboxes turned on for team "A" and find the equivalent "vs Role" for team "B"
      notRotatedGameRoleValuesSorted.forEach(
        (roleValueToCheckIfOn, roleValueToCheckIfOnIndex) => {
          if (roleValueToCheckIfOn && roleValueToCheckIfOn !== "") {
            for (
              let index = 0;
              index < rotatedGameRolesQueryStrings.length;
              index++
            ) {
              rotatedGameRolesQueryStrings[index] =
                rotatedGameRolesQueryStrings[index] +
                "|" +
                this.getEquivalentVsRole(
                  notRotatedGameRolesSorted[roleValueToCheckIfOnIndex]
                );

              rotatedGameRolesQueryStrings[index] =
                this.RemoveDuplicatedRolesAndSortAlphabetically(
                  rotatedGameRolesQueryStrings[index]
                );
              rotatedGameRolesQueryStrings[index] =
                this.sendTheRoleSeriesToTheEndOfTheOrder(
                  rotatedGameRolesQueryStrings[index]
                );
            }
          }
        }
      );
      //End Look for checkboxes turned on for team "A" and find the equivalent "vs Role" for team "B"

      //Look for checkboxes turned on for team "B" and find the equivalent "vs Role" for team "A"
      rotatedGameRoleValuesSorted.forEach(
        (roleValueToCheckIfOn, roleValueToCheckIfOnIndex) => {
          if (roleValueToCheckIfOn && roleValueToCheckIfOn !== "") {
            for (
              let index = 0;
              index < notRotatedGameRolesQueryStrings.length;
              index++
            ) {
              notRotatedGameRolesQueryStrings[index] =
                notRotatedGameRolesQueryStrings[index] +
                "|" +
                this.getEquivalentVsRole(
                  rotatedGameRolesSorted[roleValueToCheckIfOnIndex]
                );

              notRotatedGameRolesQueryStrings[index] =
                this.RemoveDuplicatedRolesAndSortAlphabetically(
                  notRotatedGameRolesQueryStrings[index]
                );
              notRotatedGameRolesQueryStrings[index] =
                this.sendTheRoleSeriesToTheEndOfTheOrder(
                  notRotatedGameRolesQueryStrings[index]
                );
            }
          }
        }
      );
      //End look for checkboxes turned on for team "B" and find the equivalent "vs Role" for team "A"
      //End Now we have to process the equivalent vs roles for the check boxes turned on for both teams

      //-----------------------------------------------------------

      //Building forcast information for team "A"
      //Get the whole data for the current NOT ROTATED GAME
      const notRotatedGameAllDataIndex = notRotatedGames.findIndex(
        (element) => element[0] == currentNotRotatedGame.notRotatedGameId
      );
      const notRotatedGameAllData = notRotatedGames[notRotatedGameAllDataIndex];
      //End get the whole data for the current NOT ROTATED GAME

      //Search the corresponding ats/ou for the roles query strings for NOT ROTATED GAME
      const notRotatedGameAllDataKeys = Array.from(
        Object.keys(notRotatedGameAllData[1])
      );
      const notRotatedGameAllDataValues = Array.from(
        Object.values(notRotatedGameAllData[1])
      );

      let notRotatedGameRolesForcast = [];
      notRotatedGameRolesQueryStrings.forEach((roleQueryString) => {
        const roleQueryStringIndex = notRotatedGameAllDataKeys.findIndex(
          (element) => element === roleQueryString
        );
        if (roleQueryStringIndex) {
          notRotatedGameRolesForcast.push(
            notRotatedGameAllDataValues[roleQueryStringIndex]
          );
        }
      });
      //End search the corresponding ats/ou for the roles query strings for NOT ROTATED GAME

      const returnElement1 = {
        notRotatedGameRoles: notRotatedGameRolesSorted,
        notRotatedGameRoleValues: notRotatedGameRoleValuesSorted,
        notRotatedGameRolesQueryStrings: notRotatedGameRolesQueryStrings,
        notRotatedGameRolesForcast: notRotatedGameRolesForcast,
      };
      //End building forcast information for team "A"

      //Building forcast information for team "B"
      //Get the whole data for the current ROTATED GAME
      const rotatedGameAllDataIndex = rotatedGames.findIndex(
        (element) => element[0] == currentRotatedGame.rotatedGameId
      );
      const rotatedGameAllData = rotatedGames[rotatedGameAllDataIndex];
      //End get the whole data for the current ROTATED GAME

      //Search the corresponding ats/ou for the roles query strings for ROTATED GAME
      const rotatedGameAllDataKeys = Array.from(
        Object.keys(rotatedGameAllData[1])
      );
      const rotatedGameAllDataValues = Array.from(
        Object.values(rotatedGameAllData[1])
      );
      let rotatedGameRolesForcast = [];
      rotatedGameRolesQueryStrings.forEach((roleQueryString) => {
        const roleQueryStringIndex = rotatedGameAllDataKeys.findIndex(
          (element) => element === roleQueryString
        );
        if (roleQueryStringIndex) {
          rotatedGameRolesForcast.push(
            rotatedGameAllDataValues[roleQueryStringIndex]
          );
        }
      });
      //End search the corresponding ats/ou for the roles query strings for ROTATED GAME

      const returnElement2 = {
        rotatedGameRoles: rotatedGameRolesSorted,
        rotatedGameRoleValues: rotatedGameRoleValuesSorted,
        rotatedGameRolesQueryStrings: rotatedGameRolesQueryStrings,
        rotatedGameRolesForcast: rotatedGameRolesForcast,
      };
      //End building forcast information for team "B"

      //-----------------------------------------------------------

      //return both objects created
      return [returnElement1, returnElement2];
    } catch (error) {
      console.error(error);
      /*gameView.renderError(error);*/
    }
  }

  sortTwoArraysBasedOnOne(arrayBasedOn, arrayToSort) {
    try {
      // Crear una copia del arreglo arrayBasedOn para no modificar el original
      const arrayBasedOnCopy = [...arrayBasedOn];

      // Crear una matriz que contenga tanto los elements de arrayBasedOn como los de arrayToSort
      let combined = arrayBasedOnCopy.map((element, index) => {
        return {
          valueArrayBasedOn: element,
          valueArrayToSort: arrayToSort[index],
        };
      });

      // Ordenar la matriz combinada basado en los valores del arreglo arrayBasedOn
      combined.sort((a, b) => {
        if (a.valueArrayBasedOn < b.valueArrayBasedOn) return -1;
        if (a.valueArrayBasedOn > b.valueArrayBasedOn) return 1;
        return 0;
      });

      // Extraer los elements ordenados de ambos arreglos
      const arrayBasedOnSorted = combined.map(
        (element) => element.valueArrayBasedOn
      );
      const arrayToSortSorted = combined.map(
        (element) => element.valueArrayToSort
      );

      return {
        arrayBasedOnSorted: arrayBasedOnSorted,
        arrayToSortSorted: arrayToSortSorted,
      };
    } catch (error) {
      console.error(error);
      /*gameView.renderError(error);*/
    }
  }

  getEquivalentVsRole(role) {
    try {
      const equivalentVsRoleTableArray = equivalentVsRoleTable;
      let equivalentVsRole = "Equivalent Role Not found";

      equivalentVsRoleTableArray.forEach((element, index) => {
        if (role == element.Role) {
          equivalentVsRole = element.vsRole;
        }
      });
      return equivalentVsRole;
    } catch (error) {
      console.error(error);
      /*gameView.renderError(error);*/
    }
  }

  RemoveDuplicatedRolesAndSortAlphabetically(rolesString) {
    try {
      //This function assumes that the separator between roles in the string parameter is "|"

      // Convert the string to array
      let rolesStringArray = rolesString.split("|");

      // Remove the repeated roles
      let rolesStringArrayUnique = [...new Set(rolesStringArray)];

      // Sort roles alphabetically no matter upper or lower cases
      rolesStringArrayUnique.sort((a, b) =>
        a.localeCompare(b, undefined, { sensitivity: "base" })
      );

      // Convert the array back to a string using '|' separator
      let result = rolesStringArrayUnique.join("|");

      return result;
    } catch (error) {
      console.error(error);
      /*gameView.renderError(error);*/
    }
  }

  sendTheRoleSeriesToTheEndOfTheOrder(rolesString) {
    try {
      //This function assumes that the separator between roles in the string parameter is "|"
      //roles are not repeated and are sorted alphabetically!

      // Convert the string to array
      let rolesStringArray = rolesString.split("|");

      // Let's Filter elements that are not "SERIES"
      let filteredArr = rolesStringArray.filter((item) => item !== "SERIES");

      // Lets count how many elements "SERIES" there are in the original array (it will be allways 1)
      const seriesCount = rolesStringArray.length - filteredArr.length;

      // Create an array with the amount of elements found (it will be allways 1)
      const seriesArr = Array(seriesCount).fill("SERIES");

      // Let's Combine the arrays
      filteredArr = filteredArr.concat(seriesArr);

      // Convert the array back to a string using '|' separator
      let result = filteredArr.join("|");

      return result;
    } catch (error) {
      console.error(error);
      /*gameView.renderError(error);*/
    }
  }

  getRotatedGameId(notRotatedGameId, notRotatedGames, rotatedGames) {
    try {
      const notRotatedGame = notRotatedGames.find(
        (element) => element[0] == notRotatedGameId
      );

      const notRotatedGameDate = notRotatedGame[1].dEventDate;
      const notRotatedGameTeamA = notRotatedGame[1].tTeamName;
      const notRotatedGameTeamB = notRotatedGame[1].tFoeName;

      const rotatedGame = rotatedGames.find(
        (element) =>
          element[1].dEventDate == notRotatedGameDate &&
          element[1].tTeamName == notRotatedGameTeamB &&
          element[1].tFoeName == notRotatedGameTeamA
      );

      return rotatedGame[0];
    } catch (error) {
      console.error(error);
      /*gameView.renderError(error);*/
    }
  }
}
export default new GameModel();

// Model routines for the games
// Vicente Padulo
// Feb 23,2025
// https://Vicentepadulo.com.ve
