class GameView {
  async renderGamesList(notRotatedgames, rotatedgames, parentHtmlId) {
    try {
      if (!notRotatedgames || !rotatedgames) {
        throw new Error("Error during games data array creation!");
      } else {
        const parentElement = document.querySelector("#" + parentHtmlId);

        let baseHtmlString =
          '<div style=display:flex><div class="col-12 col-lg-6 col-sm-12 col-md-12"><h5 style=text-align:center;border-style:solid;border-color:red>Game Id: %notRotatedGameId%</h5><div class="card p-3"><div class="d-flex justify-content-between"><div class=lines><h5 class=text-center><strong>SU</strong></h5><h6 class=text-center><strong>%SUYearTallyTeamA%</strong></h6><h5 class="text-center mt-3"><strong>ATS</strong></h5><h6 class=text-center><strong>%ATSYearTallyTeamA%</strong></h6><h5 class="text-center mt-3"><strong>OU</strong></h5><h6 class=text-center><strong>%OUYearTallyTeamA%</strong></h6></div><div class=teams><h5 class="text-center mb-3"><strong>%teamA%</strong></h5><img alt=""class="d-block mx-auto img-fluid nbalogo-custom"height=80 src=img/nfllogo/nyj.png width=80><h5 class="text-center mt-3"><strong>%nameTeamA%</strong></h5></div><div class=teams><h5 class="text-center mb-3"><strong>%teamB%</strong></h5><img alt=""class="d-block mx-auto img-fluid nbalogo-custom"height=80 src=img/nfllogo/SF.png width=80><h5 class="text-center mt-3"><strong>%nameTeamB%</strong></h5></div><div class=lines><h5 class=text-center><strong>SU</strong></h5><h6 class=text-center><strong>%SUYearTallyTeamB%</strong></h6><h5 class="text-center mt-3"><strong>ATS</strong></h5><h6 class=text-center><strong>%ATSYearTallyTeamB%</strong></h6><h5 class="text-center mt-3"><strong>OU</strong></h5><h6 class=text-center><strong>%OUYearTallyTeamB%</strong></h6></div></div></div><div class="justify-content-center mx-0 row"><div class="col-12 col-lg-6 col-sm-12 col-md-6 my-2 px-md-1"data-not-rotated-game-id=%notRotatedGameId%><div class=d-flex><div class="card card-rounded pb-3 pt-2 px-2 w-100"><div class="d-flex justify-content-between align-items-start"><span class=d-block><b class=role>%somethingUpLeftTeamALabel%</b><div class="custom-checkbox custom-control"><input id=%htmlId% type=checkbox class=custom-control-input data-not-rotated-game-role=%somethingUpLeftTeamA%> <label for=%htmlId% class=custom-control-label></label></div></span><div><img alt=""class="d-block mx-auto"height=30 src=img/nfllogo/nyj.png width=30></div><span class=d-block><b class=role>%homeAwayTeamALabel%</b><div class="custom-checkbox custom-control homeAwayTeamA"><input id=%htmlId% type=checkbox class="custom-control-input home-away"data-not-rotated-game-role=%homeAwayTeamA%> <label for=%htmlId% class=custom-control-label></label></div></span></div><div class="d-flex justify-content-between align-items-end"><div data-not-rotated-game-role=%somethingUpLeftTeamA%><span class=d-block>0-0</span> <span class=d-block>0-0</span></div><div><span class=d-block><strong>ATS</strong></span> <span class=d-block><strong>OU</strong></span></div><div data-not-rotated-game-role=%homeAwayTeamA%><span class=d-block>0-0</span> <span class=d-block>0-0</span></div></div></div></div></div><div class="col-12 col-lg-6 col-sm-12 col-md-6 my-2 px-md-1"data-rotated-game-id=%rotatedGameId%><div class=d-flex><div class="card card-rounded pb-3 pt-2 px-2 w-100"><div class="d-flex justify-content-between align-items-start"><span class=d-block><b class=role>%homeAwayTeamBLabel%</b><div class="custom-checkbox custom-control"><input id=%htmlId% type=checkbox class="custom-control-input home-away"data-rotated-game-role=%homeAwayTeamB%> <label for=%htmlId% class=custom-control-label></label></div></span><div><img alt=""class="d-block mx-auto"height=30 src=img/nfllogo/SF.png width=30></div><span class=d-block><b class=role>%somethingUpRightTeamBLabel%</b><div class="custom-checkbox custom-control somethingUpRightTeamB"><input id=%htmlId% type=checkbox class=custom-control-input data-rotated-game-role=%somethingUpRightTeamB%> <label for=%htmlId% class=custom-control-label></label></div></span></div><div class="d-flex justify-content-between align-items-end"><div data-rotated-game-role=%homeAwayTeamB%><span class=d-block>0-0</span> <span class=d-block>0-0</span></div><div><span class=d-block><strong>ATS</strong></span> <span class=d-block><strong>OU</strong></span></div><div data-rotated-game-role=%somethingUpRightTeamB%><span class=d-block>0-0</span> <span class=d-block>0-0</span></div></div></div></div></div><div class="col-12 col-lg-6 col-sm-12 col-md-6 my-2 px-md-1"data-not-rotated-game-id=%notRotatedGameId%><div class=d-flex><div class="card card-rounded pb-3 pt-2 px-2 w-100"><div class="d-flex justify-content-between align-items-start"><span class=d-block><b class=role>%somethingDownLeftTeamALabel%</b><div class="custom-checkbox custom-control"><input id=%htmlId% type=checkbox class=custom-control-input data-not-rotated-game-role=%somethingDownLeftTeamA%> <label for=%htmlId% class=custom-control-label></label></div></span><div><img alt=""class="d-block mx-auto"height=30 src=img/nfllogo/nyj.png width=30></div><span class=d-block><b class=role>%favoriteDogTeamALabel%</b><div class="custom-checkbox custom-control favoriteDogTeamA"><input id=%htmlId% type=checkbox class="custom-control-input favorite-dog"data-not-rotated-game-role=%favoriteDogTeamA%> <label for=%htmlId% class=custom-control-label></label></div></span></div><div class="d-flex justify-content-between align-items-end"><div data-not-rotated-game-role=%somethingDownLeftTeamA%><span class=d-block>0-0</span> <span class=d-block>0-0</span></div><div><span class=d-block><strong>ATS</strong></span> <span class=d-block><strong>OU</strong></span></div><div data-not-rotated-game-role=%favoriteDogTeamA%><span class=d-block>0-0</span> <span class=d-block>0-0</span></div></div></div></div></div><div class="col-12 col-lg-6 col-sm-12 col-md-6 my-2 px-md-1"data-rotated-game-id=%rotatedGameId%><div class=d-flex><div class="card card-rounded pb-3 pt-2 px-2 w-100"><div class="d-flex justify-content-between align-items-start"><span class=d-block><b class=role>%favoriteDogTeamBLabel%</b><div class="custom-checkbox custom-control"><input id=%htmlId% type=checkbox class="custom-control-input favorite-dog"data-rotated-game-role=%favoriteDogTeamB%> <label for=%htmlId% class=custom-control-label></label></div></span><div><img alt=""class="d-block mx-auto"height=30 src=img/nfllogo/SF.png width=30></div><span class=d-block><b class=role>%somethingDownRightTeamBLabel%</b><div class="custom-checkbox custom-control somethingDownRightTeamB"><input id=%htmlId% type=checkbox class=custom-control-input data-rotated-game-role=%somethingDownRightTeamB%> <label for=%htmlId% class=custom-control-label></label></div></span></div><div class="d-flex justify-content-between align-items-end"><div data-rotated-game-role=%favoriteDogTeamB%><span class=d-block>0-0</span> <span class=d-block>0-0</span></div><div><span class=d-block><strong>ATS</strong></span> <span class=d-block><strong>OU</strong></span></div><div data-rotated-game-role=%somethingDownRightTeamB%><span class=d-block>0-0</span> <span class=d-block>0-0</span></div></div></div></div></div></div><div class="d-flex justify-content-center mb-3"><div class=d-flex><form class=YDTSeriesRadioButtons data-not-rotated-game-id=%notRotatedGameId%><label for=%htmlId%><input id=%htmlId% type=radio name=opciones value=1 checked>YTD</label><br><label for=%htmlId%><input id=%htmlId% type=radio name=opciones value=2>Series</label></form><button class="card btn searchForcast"data-not-rotated-game-id=%notRotatedGameId% onclick=controlApplyFilters()>Apply Filters</button> <button class="card btn"data-not-rotated-game-id=%notRotatedGameId% onclick=controlClearFilters()>Clear</button></div></div><div class="d-flex justify-content-center mb-3 errorMessage"><span>No errors so far!</span></div></div><div class="col-12 col-lg-6 col-sm-12 col-md-12"style=border-style:solid;border-color:red;margin-bottom:50px><div><b class=test data-not-rotated-game-id=%notRotatedGameId%>Not Rotated Game: %notRotatedGameId%</b></div><div><b class=test data-rotated-game-id=%rotatedGameId%>Rotated Game: %rotatedGameId%</b></div></div></div>';

        let markup = "";
        let sortedRoles = [];
        let htmlId = 0;

        notRotatedgames.forEach((element, index) => {
          markup = baseHtmlString;
          markup = markup.replaceAll("%notRotatedGameId%", element[0]);
          markup = markup.replaceAll("%rotatedGameId%", rotatedgames[index][0]);

          markup = markup.replaceAll(
            "%OUYearTallyTeamA%",
            element[1].tOUYearTally
          );
          markup = markup.replaceAll(
            "%ATSYearTallyTeamA%",
            element[1].tATSYearTally
          );
          markup = markup.replaceAll(
            "%SUYearTallyTeamA%",
            element[1].tSUYearTally
          );

          markup = markup.replaceAll(
            "%OUYearTallyTeamB%",
            rotatedgames[index][1].tOUYearTally
          );
          markup = markup.replaceAll(
            "%ATSYearTallyTeamB%",
            rotatedgames[index][1].tATSYearTally
          );
          markup = markup.replaceAll(
            "%SUYearTallyTeamB%",
            rotatedgames[index][1].tSUYearTally
          );

          markup = markup.replaceAll("%teamA%", element[1].iRotationID);
          markup = markup.replaceAll(
            "%teamB%",
            rotatedgames[index][1].iRotationID
          );

          sortedRoles = this.AssignGameRoles(element[1].colGameRoles);

          markup = markup.replaceAll("%nameTeamA%", element[1].tTeamName);
          markup = markup.replaceAll("%nameTeamB%", element[1].tFoeName);
          markup = markup.replaceAll(
            "%somethingUpLeftTeamALabel%",
            sortedRoles[2] ? sortedRoles[2].replace("_", " ") : "Not set"
          );
          markup = markup.replaceAll(
            "%somethingUpLeftTeamA%",
            sortedRoles[2] ? sortedRoles[2] : "Not set"
          );
          htmlId = ++htmlId;
          markup = markup.replace("%htmlId%", htmlId);
          markup = markup.replace("%htmlId%", htmlId);
          markup = markup.replaceAll(
            "%homeAwayTeamALabel%",
            sortedRoles[0] ? sortedRoles[0].replace("_", " ") : "Not set"
          );
          markup = markup.replaceAll(
            "%homeAwayTeamA%",
            sortedRoles[0] ? sortedRoles[0] : "Not set"
          );
          htmlId = ++htmlId;
          markup = markup.replace("%htmlId%", htmlId);
          markup = markup.replace("%htmlId%", htmlId);
          markup = markup.replaceAll(
            "%homeAwayTeamBLabel%",
            sortedRoles[4] ? sortedRoles[4].replace("_", " ") : "Not set"
          );
          markup = markup.replaceAll(
            "%homeAwayTeamB%",
            sortedRoles[4] ? sortedRoles[4] : "Not set"
          );
          htmlId = ++htmlId;
          markup = markup.replace("%htmlId%", htmlId);
          markup = markup.replace("%htmlId%", htmlId);
          markup = markup.replaceAll(
            "%somethingUpRightTeamBLabel%",
            sortedRoles[6] ? sortedRoles[6].replace("_", " ") : "Not set"
          );
          markup = markup.replaceAll(
            "%somethingUpRightTeamB%",
            sortedRoles[6] ? sortedRoles[6] : "Not set"
          );
          htmlId = ++htmlId;
          markup = markup.replace("%htmlId%", htmlId);
          markup = markup.replace("%htmlId%", htmlId);
          markup = markup.replaceAll(
            "%somethingDownLeftTeamALabel%",
            sortedRoles[3] ? sortedRoles[3].replace("_", " ") : "Not set"
          );
          markup = markup.replaceAll(
            "%somethingDownLeftTeamA%",
            sortedRoles[3] ? sortedRoles[3] : "Not set"
          );
          htmlId = ++htmlId;
          markup = markup.replace("%htmlId%", htmlId);
          markup = markup.replace("%htmlId%", htmlId);
          markup = markup.replaceAll(
            "%favoriteDogTeamALabel%",
            sortedRoles[1] ? sortedRoles[1].replace("_", " ") : "Not set"
          );
          markup = markup.replaceAll(
            "%favoriteDogTeamA%",
            sortedRoles[1] ? sortedRoles[1] : "Not set"
          );
          htmlId = ++htmlId;
          markup = markup.replace("%htmlId%", htmlId);
          markup = markup.replace("%htmlId%", htmlId);
          markup = markup.replaceAll(
            "%favoriteDogTeamBLabel%",
            sortedRoles[5] ? sortedRoles[5].replace("_", " ") : "Not set"
          );
          markup = markup.replaceAll(
            "%favoriteDogTeamB%",
            sortedRoles[5] ? sortedRoles[5] : "Not set"
          );
          htmlId = ++htmlId;
          markup = markup.replace("%htmlId%", htmlId);
          markup = markup.replace("%htmlId%", htmlId);
          markup = markup.replaceAll(
            "%somethingDownRightTeamBLabel%",
            sortedRoles[7] ? sortedRoles[7].replace("_", " ") : "Not set"
          );
          markup = markup.replaceAll(
            "%somethingDownRightTeamB%",
            sortedRoles[7] ? sortedRoles[7] : "Not set"
          );
          htmlId = ++htmlId;
          markup = markup.replace("%htmlId%", htmlId);
          markup = markup.replace("%htmlId%", htmlId);

          htmlId = ++htmlId;
          markup = markup.replace("%htmlId%", htmlId);
          markup = markup.replace("%htmlId%", htmlId);
          htmlId = ++htmlId;
          markup = markup.replace("%htmlId%", htmlId);
          markup = markup.replace("%htmlId%", htmlId);

          parentElement.insertAdjacentHTML("afterbegin", markup);
        });
      }
    } catch (error) {
      console.error(error);
      /*gameView.renderError(error);*/
    }
  }

  AssignGameRoles(asortedGameRoles) {
    /*get the asorted roles and return them ordered first the four roles for game "A" to be placed in the interface left to right and up to down, and then the four roles for team "B" to be placed in the interface left to right and up to down.
    
    The order is:
    
    1st Home/away team "A"
    2nd Favorite/Doug team "A"
    3rd off_Road/off_home team "A"
    4th off_favorite/off_doug team "A"
    5th Home/away team "B"
    6th Favorite/Doug team "B"
    7th off_Road/off_home team "B"
    8th off_favorite/off_doug team "B"
    */
    try {
      let sortedRoles = [];

      asortedGameRoles.forEach((element) => {
        switch (element) {
          case "HOME":
            sortedRoles[0] = "HOME";
            break;
          case "AWAY":
            sortedRoles[0] = "AWAY";
            break;
          case "FAVORITE":
            sortedRoles[1] = "FAVORITE";
            break;
          case "DOG":
            sortedRoles[1] = "DOG";
            break;
          case "OFF_HOME":
            sortedRoles[2] = "OFF_HOME";
            break;
          case "OFF_ROAD":
            sortedRoles[2] = "OFF_ROAD";
            break;
          case "OFF_FAVORITE":
            sortedRoles[3] = "OFF_FAVORITE";
            break;
          case "OFF_DOG":
            sortedRoles[3] = "OFF_DOG";
            break;
          case "vs HOME":
            sortedRoles[4] = "HOME";
            break;
          case "vs AWAY":
            sortedRoles[4] = "AWAY";
            break;
          case "vs FAVORITE":
            sortedRoles[5] = "FAVORITE";
            break;
          case "vs DOG":
            sortedRoles[5] = "DOG";
            break;
          case "vs OFF_HOME":
            sortedRoles[6] = "OFF_HOME";
            break;
          case "vs OFF_ROAD":
            sortedRoles[6] = "OFF_ROAD";
            break;
          case "vs OFF_FAVORITE":
            sortedRoles[7] = "OFF_FAVORITE";
            break;
          case "vs OFF_DOG":
            sortedRoles[7] = "OFF_DOG";
            break;
          default:
            break;
        }
      });

      return sortedRoles;
    } catch (error) {
      console.error(error);
      /*gameView.renderError(error);*/
    }
  }

  manageHomeAwayFavoriteDogCheckboxes(homeAwayOrFavoriteDog) {
    try {
      const classes = Array.from(event.target.classList);

      if (
        event.target.type === "checkbox" &&
        classes.includes(homeAwayOrFavoriteDog)
      ) {
        let checkboxes = document.querySelectorAll(
          `input[type="checkbox"].custom-control-input.${homeAwayOrFavoriteDog}`
        );
        let closestCheckbox = null;
        let closestDistance = Infinity;

        checkboxes.forEach(function (checkbox) {
          if (checkbox !== event.target) {
            let distance = Math.abs(
              event.target.getBoundingClientRect().top -
                checkbox.getBoundingClientRect().top
            );
            if (distance < closestDistance) {
              closestDistance = distance;
              closestCheckbox = checkbox;
            }
          }
        });
        if (closestCheckbox) {
          if (event.target.checked) {
            closestCheckbox.checked = true;
          } else {
            closestCheckbox.checked = false;
          }
        }
      }
    } catch (error) {
      console.error(error);
      /*gameView.renderError(error);*/
    }
  }

  clearGameInformationFromDom(notRotatedGameId, rotatedGameId) {
    try {
      /*const notRotatedGameRoles = document.querySelectorAll(
        `[data-not-rotated-game-id="${notRotatedGameId}"] b.role`
      );*/

      const notRotatedGameRoles = document.querySelectorAll(
        `[data-not-rotated-game-id="${notRotatedGameId}"] div.custom-checkbox.custom-control input[type="checkbox"].custom-control-input`
      );

      /*const notRotatedGameRolesArray = Array.from(notRotatedGameRoles).map(
        (elemento) => elemento.textContent
      );*/

      const notRotatedGameRolesArray = Array.from(notRotatedGameRoles).map(
        (elemento) => elemento.getAttribute("data-not-rotated-game-role")
      );

      const notRotatedGameRoleValues = document.querySelectorAll(
        `[data-not-rotated-game-id="${notRotatedGameId}"] div.custom-checkbox.custom-control input[type="checkbox"].custom-control-input`
      );

      const notRotatedGameRoleValuesArray = [];
      notRotatedGameRoleValues.forEach(function (element) {
        element.checked = false;
        notRotatedGameRoleValuesArray.push(false);
      });

      const notRotatedGameDomInfo = {
        notRotatedGameId: notRotatedGameId,
        notRotatedGameRoles: notRotatedGameRolesArray,
        notRotatedGameRoleValues: notRotatedGameRoleValuesArray,
      };

      // --------------------- rotatedGame dom information
      /*const rotatedGameRoles = document.querySelectorAll(
        `[data-rotated-game-id="${rotatedGameId}"] b.role`
      );*/

      const rotatedGameRoles = document.querySelectorAll(
        `[data-rotated-game-id="${rotatedGameId}"] div.custom-checkbox.custom-control input[type="checkbox"].custom-control-input`
      );

      /*const rotatedGameRolesArray = Array.from(rotatedGameRoles).map(
        (elemento) => elemento.textContent
      );*/

      const rotatedGameRolesArray = Array.from(rotatedGameRoles).map(
        (elemento) => elemento.getAttribute("data-rotated-game-role")
      );

      const rotatedGameRoleValues = document.querySelectorAll(
        `[data-rotated-game-id="${rotatedGameId}"] div.custom-checkbox.custom-control input[type="checkbox"].custom-control-input`
      );

      const rotatedGameRoleValuesArray = [];
      rotatedGameRoleValues.forEach(function (element) {
        element.checked = false;
        rotatedGameRoleValuesArray.push(false);
      });

      const rotatedGameDomInfo = {
        rotatedGameId: rotatedGameId,
        rotatedGameRoles: rotatedGameRolesArray,
        rotatedGameRoleValues: rotatedGameRoleValuesArray,
      };
      //--------------------- YTD or Series
      const ytdSeriesValues = document.querySelector(
        `[data-not-rotated-game-id="${notRotatedGameId}"] input[type="radio"]`
      );

      let ytdSeries = "YTD";
      ytdSeriesValues.checked = true;

      return [notRotatedGameDomInfo, rotatedGameDomInfo, ytdSeries];
    } catch (error) {
      console.error(error);
      /*gameView.renderError(error);*/
    }
  }

  getGameInformationFromDom(notRotatedGameId, rotatedGameId) {
    try {
      // --------------------- notRotatedGame dom information
      /*const notRotatedGameRoles = document.querySelectorAll(
        `[data-not-rotated-game-id="${notRotatedGameId}"] b.role`
      );*/

      const notRotatedGameRoles = document.querySelectorAll(
        `[data-not-rotated-game-id="${notRotatedGameId}"] div.custom-checkbox.custom-control input[type="checkbox"].custom-control-input`
      );

      /*const notRotatedGameRolesArray = Array.from(notRotatedGameRoles).map(
        (elemento) => elemento.textContent
      );*/

      const notRotatedGameRolesArray = Array.from(notRotatedGameRoles).map(
        (elemento) => elemento.getAttribute("data-not-rotated-game-role")
      );

      const notRotatedGameRoleValues = document.querySelectorAll(
        `[data-not-rotated-game-id="${notRotatedGameId}"] div.custom-checkbox.custom-control input[type="checkbox"].custom-control-input`
      );

      const notRotatedGameRoleValuesArray = [];
      notRotatedGameRoleValues.forEach(function (element) {
        notRotatedGameRoleValuesArray.push(element.checked);
      });

      const notRotatedGameDomInfo = {
        notRotatedGameId: notRotatedGameId,
        notRotatedGameRoles: notRotatedGameRolesArray,
        notRotatedGameRoleValues: notRotatedGameRoleValuesArray,
      };
      // --------------------- rotatedGame dom information
      /*const rotatedGameRoles = document.querySelectorAll(
        `[data-rotated-game-id="${rotatedGameId}"] b.role`
      );*/

      const rotatedGameRoles = document.querySelectorAll(
        `[data-rotated-game-id="${rotatedGameId}"] div.custom-checkbox.custom-control input[type="checkbox"].custom-control-input`
      );

      /*const rotatedGameRolesArray = Array.from(rotatedGameRoles).map(
        (elemento) => elemento.textContent
      );*/

      const rotatedGameRolesArray = Array.from(rotatedGameRoles).map(
        (elemento) => elemento.getAttribute("data-rotated-game-role")
      );

      const rotatedGameRoleValues = document.querySelectorAll(
        `[data-rotated-game-id="${rotatedGameId}"] div.custom-checkbox.custom-control input[type="checkbox"].custom-control-input`
      );

      const rotatedGameRoleValuesArray = [];
      rotatedGameRoleValues.forEach(function (element) {
        rotatedGameRoleValuesArray.push(element.checked);
      });

      const rotatedGameDomInfo = {
        rotatedGameId: rotatedGameId,
        rotatedGameRoles: rotatedGameRolesArray,
        rotatedGameRoleValues: rotatedGameRoleValuesArray,
      };
      //--------------------- YTD or Series
      const ytdSeriesValues = document.querySelector(
        `[data-not-rotated-game-id="${notRotatedGameId}"] input[type="radio"]`
      );

      let ytdSeries = "";

      if (ytdSeriesValues.checked) {
        ytdSeries = "YTD";
      } else {
        ytdSeries = "SERIES";
      }

      return [notRotatedGameDomInfo, rotatedGameDomInfo, ytdSeries];
    } catch (error) {
      console.error(error);
      /*gameView.renderError(error);*/
    }
  }

  renderGameForcastInformation(
    notRotatedGameId,
    notRotatedGameRoles,
    notRotatedGameRolesForcast,
    rotatedGameId,
    rotatedGameRoles,
    rotatedGameRolesForcast
  ) {
    try {
      for (let index = 0; index < notRotatedGameRoles.length; index++) {
        let role = notRotatedGameRoles[index];
        const atsOu = document.querySelector(
          `[data-not-rotated-game-id="${notRotatedGameId}"] div[data-not-rotated-game-role="${role}"]`
        );

        if (atsOu) {
          if (
            notRotatedGameRolesForcast[index] &&
            !notRotatedGameRolesForcast[index] == ""
          ) {
            atsOu.children[0].textContent =
              notRotatedGameRolesForcast[index].tATSTally;
            atsOu.children[1].textContent =
              notRotatedGameRolesForcast[index].tOUTally;
          } else {
            atsOu.children[0].textContent = " ";
            atsOu.children[1].textContent = " ";
          }
        }
      }

      for (let index = 0; index < rotatedGameRoles.length; index++) {
        let role = rotatedGameRoles[index];
        const atsOu = document.querySelector(
          `[data-rotated-game-id="${rotatedGameId}"] div[data-rotated-game-role="${role}"]`
        );

        if (atsOu) {
          if (
            rotatedGameRolesForcast[index] &&
            !rotatedGameRolesForcast[index] == ""
          ) {
            atsOu.children[0].textContent =
              rotatedGameRolesForcast[index].tATSTally;
            atsOu.children[1].textContent =
              rotatedGameRolesForcast[index].tOUTally;
          } else {
            atsOu.children[0].textContent = " ";
            atsOu.children[1].textContent = " ";
          }
        }
      }
    } catch (error) {
      console.error(error);
      /*gameView.renderError(error);*/
    }
  }

  getCurrentNotRotatedGameIdFromDomTarget(domEventTarget) {
    try {
      const currentNotRotatedGameId = domEventTarget.getAttribute(
        "data-not-rotated-game-id"
      );
      return currentNotRotatedGameId;
    } catch (error) {
      console.error(error);
      /*gameView.renderError(error);*/
    }
  }

  addHandlerSearchGames(handler) {
    try {
      window.addEventListener("load", handler);
    } catch (error) {
      console.error(error);
      /*gameView.renderError(error);*/
    }
  }

  addHandlerHomeAwayFavoriteDogCheckboxes(handler) {
    try {
      window.addEventListener("click", handler);
    } catch (error) {
      console.error(error);
      /*gameView.renderError(error);*/
    }
  }

  /*renderError(error) {
    const div = document.querySelector(".errorMessage");
    if (div) {
      div.innerHTML = `<span>Name: ${error}</span>`;
      div.style.visibility = "visible";
    } else {
      div.style.visibility = "hidden";
    }
  }*/

  showTestingInformation(
    notRotatedGameId,
    notRotatedGameRoles,
    notRotatedGameRoleValues,
    notRotatedGameRolesQueryStrings,
    notRotatedGameRolesForcast,
    rotatedGameId,
    rotatedGameRoles,
    rotatedGameRoleValues,
    rotatedGameRolesQueryStrings,
    rotatedGameRolesForcast
  ) {
    /*Remove it before implementation in production*/

    const currentNotRotatedGameDomNode = document.querySelector(
      `b.test[data-not-rotated-game-id="${notRotatedGameId}"]`
    );

    if (currentNotRotatedGameDomNode) {
      while (currentNotRotatedGameDomNode.nextSibling) {
        currentNotRotatedGameDomNode.nextSibling.remove();
      }

      let newParagraph = document.createElement("p");
      newParagraph.textContent =
        "Game Roles Forcast: " +
        JSON.stringify(notRotatedGameRolesForcast, null, 2);
      currentNotRotatedGameDomNode.parentNode.insertBefore(
        newParagraph,
        currentNotRotatedGameDomNode.nextSibling
      );

      newParagraph = document.createElement("p");
      newParagraph.textContent =
        "Game Roles Query Strings: " + notRotatedGameRolesQueryStrings;
      currentNotRotatedGameDomNode.parentNode.insertBefore(
        newParagraph,
        currentNotRotatedGameDomNode.nextSibling
      );

      newParagraph = document.createElement("p");
      newParagraph.textContent =
        "Game Role Values: " + notRotatedGameRoleValues;
      currentNotRotatedGameDomNode.parentNode.insertBefore(
        newParagraph,
        currentNotRotatedGameDomNode.nextSibling
      );

      newParagraph = document.createElement("p");
      newParagraph.textContent = "Game Roles: " + notRotatedGameRoles;
      currentNotRotatedGameDomNode.parentNode.insertBefore(
        newParagraph,
        currentNotRotatedGameDomNode.nextSibling
      );

      newParagraph = document.createElement("p");
      newParagraph.textContent = '***** TEAM "A" *****';
      currentNotRotatedGameDomNode.parentNode.insertBefore(
        newParagraph,
        currentNotRotatedGameDomNode.nextSibling
      );
    }

    const currentRotatedGameDomNode = document.querySelector(
      `b.test[data-rotated-game-id="${rotatedGameId}"]`
    );

    if (currentRotatedGameDomNode) {
      while (currentRotatedGameDomNode.nextSibling) {
        currentRotatedGameDomNode.nextSibling.remove();
      }

      let newParagraph = document.createElement("p");
      newParagraph.textContent =
        "Game Roles Forcast: " +
        JSON.stringify(rotatedGameRolesForcast, null, 2);
      currentRotatedGameDomNode.parentNode.insertBefore(
        newParagraph,
        currentRotatedGameDomNode.nextSibling
      );

      newParagraph = document.createElement("p");
      newParagraph.textContent =
        "Game Roles Query Strings: " + rotatedGameRolesQueryStrings;
      currentRotatedGameDomNode.parentNode.insertBefore(
        newParagraph,
        currentRotatedGameDomNode.nextSibling
      );

      newParagraph = document.createElement("p");
      newParagraph.textContent = "Game Role Values: " + rotatedGameRoleValues;
      currentRotatedGameDomNode.parentNode.insertBefore(
        newParagraph,
        currentRotatedGameDomNode.nextSibling
      );

      newParagraph = document.createElement("p");
      newParagraph.textContent = "Game Roles: " + rotatedGameRoles;
      currentRotatedGameDomNode.parentNode.insertBefore(
        newParagraph,
        currentRotatedGameDomNode.nextSibling
      );

      newParagraph = document.createElement("p");
      newParagraph.textContent = '***** TEAM "B" *****';
      currentRotatedGameDomNode.parentNode.insertBefore(
        newParagraph,
        currentRotatedGameDomNode.nextSibling
      );
    }
  }
}

export default new GameView();

// Views routines for games
// Vicente Padulo
// Feb 23,2025
// https://Vicentepadulo.com.ve
